/*************************************************************************
 * The contents of this file are subject to the MYRICOM MX AND GM-2      *
 * MAPPING SOFTWARE AND DOCUMENTATION LICENSE (the "License"); User may  *
 * not use this file except in compliance with the License.  The full    *
 * text of the License can found in mapper directory in LICENSE.TXT      *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
  count unique routes
*/

#include <stdarg.h>

#include "lx.h"
#include "lx_map_file.h"
#include "lx_routing.h"
#include "lx_route_file.h"

lx_t lx;

static void usage (char*s)
{
  fprintf (stderr, "usage: %s <map file> [<route file>]\n", s);
  exit (0);
}


int main (int argc, char*argv [])
{
  lx_map_t*m;
  FILE*fp;
  int i, j, o, k, t, from, num_hosts, num_ports, num_routes, line_count;
  lx_route_table_entry_t*entries, *e1, *e2;
  lx_node_t*first;  
  int valid, count;
  
  mi_verbose_flag = 0;

  if (argc < 2)
    usage (argv [0]);
  
  if (!(fp = fopen (argv [1], "r")))
  {
    fprintf (stderr, "couldn't open %s\n", argv [1]);
    usage (argv [0]);
  }
  
  lx_init (&lx);
  
  if (!lx_map_file_read (fp, &lx.maps [0], &first))
  {
    fprintf (stderr, "lx_map_file_read () failed\n");
    return 0;
  }

  m = lx.maps;
  fprintf (stderr, "%d hosts and %d xbars\n", m->num_hosts, m->num_xbars);

  if (!(fp = argc == 2 ? stdin : fopen (argv [2], "r")))
  {
    fprintf (stderr, "couldn't open %s", argv [2]);
    usage (argv [0]);
  }
  
  line_count = 0;
  count = valid = 0;
  
  while ((entries = lx_route_file_read_routes (fp, &from, &num_hosts, &num_ports, &num_routes, &line_count)))
  {
    insist (from >= 0 && from < m->num_hosts);
    insist (num_hosts == m->num_hosts);
    insist (num_ports > 0 && num_ports <= LX_HOST_SIZE);
    insist (num_routes > 0);
    
    for (i = 0; i < num_hosts; i++)
    {
      for (j = 0; j < num_ports; j++)
      {
	for (o = 0; o < num_ports; o++)
	{ 
	  for (k = 0; k < num_routes; k++)
	  {
	    e1 = lx_route_file_entry (entries, num_ports, num_hosts, num_routes, j, i, o, k);
	    insist (e1);

	    if (!e1->valid) continue;
	 
	    valid++;
	    
	    for (t = 0; t < num_routes; t++)
	    {
	      if (t == k) continue;
	      
	      e2 = lx_route_file_entry (entries, num_ports, num_hosts, num_routes, j, i, o, t);
	      insist (e2);
		
	      if (!e2->valid) continue;
	      
	      if (e1->route.length == e2->route.length && !lx_memcmp (e1->route.hops, e2->route.hops, e1->route.length))
		break;
	    }
	    if (t == num_routes) count++;
	  }
	}
      }
    }
  }
  free (entries);
  printf ("%d / %d unique routes\n", count, valid);
  
  return 1;
  except: return 0;
}
